# Want to contribute?

Did you know that you could be instrumental in making Jetpack more robust and secure? If you use and love Jetpack, why not contribute to the project?

## Contributing for Everyone!

Whether you can barely recognize a filter (or don’t know what that means) or you’ve already authored your own plugins, there are ways for you to pitch in.

### Beta Testing

Beta testers give updates, fixes, and new modules a test run before they’re publicly released, so they’re an important part of the development process. If you'd like to join our Beta group, [contact us](http://jetpack.me/contact-support/)!

### Create Bug Reports

If you find a bug, let us know by creating a new issue [here](https://github.com/Automattic/jetpack/issues/new). You can [check our recommendations to create great bug reports here](http://jetpack.me/contribute/#bugs).

### Write and submit a patch

If you'd like to fix a bug, you can submit a Pull Request. [Follow these detailed steps to find out how](http://jetpack.me/contribute/#patch).

When creating Pull Requests, remember:

- [Check In Early, Check In Often](http://blog.codinghorror.com/check-in-early-check-in-often/).
- Write [good commit messages](http://tbaggery.com/2008/04/19/a-note-about-git-commit-messages.html).
- Respect the [Best practices for WordPress development](http://jetpack.me/contribute/#practices).

There are a few bonuses that can increase the chances that your Pull Request is accepted:

- If you've created a new action or filter, [add inline documentation](https://make.wordpress.org/core/handbook/inline-documentation-standards/php-documentation-standards/#4-hooks-actions-and-filters) to help others understand how to use the action or the filter.
- Create [unit tests](https://github.com/Automattic/jetpack/tree/master/tests) if you can. If you're not familiar with Unit Testing, you can check [this tutorial](https://pippinsplugins.com/series/unit-tests-wordpress-plugins/).
- If [Grunt](http://gruntjs.com/) is installed on your testing environmenent, run it after committing your changes. It will allow you to [detect errors in Javascript files](http://jshint.com/about/), compile Sass to CSS, and [a few other things](https://github.com/Automattic/jetpack/blob/master/Gruntfile.js).

#### Where to get started?

If you'd like to contribute but don't know where to get started, you can take a look at existing issues:

- ["Good First Bug"](https://github.com/Automattic/Jetpack/issues?q=is%3Aopen+is%3Aissue+label%3A%22Good+First+Bug%22) issues are a good entry point to get familiar with Jetpack's codebase.
- ["Whisky"](https://github.com/Automattic/jetpack/labels/Whisky%20Ticket) issues are important bugs or enhancements. Take a crack at it if you feel adventurous! :)
